<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}
// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CShortcodes extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		$this->name = "shortcodes";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == $this->name) {
			$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule($this->name);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			//$this->__install();

			$this->__initTemplates(array(
				"admin"	=> "admin.htm"
			));

			switch ($sub) {

				case "landing":					
					$this->UpdateShortcodesList();

					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);

					$data->functions = array( 
							"list_process"		=> array(&$this , "ShortcodesList"),
					);					

					return $data->DoEvents();
				break;

				case "browser":
					return $this->Browser();
				break;

				case "duplicate":
					return $this->Duplicate();
				break;

				case "help":
					return $this->Help();
				break;

			}
		}
	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Browser() {
		global $base;
		
		$tpl = new CTemplateDynamic($this->tpl_path . "codes.htm");

		$items = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['plugin:shortcodes']} ORDER BY shortcode_code ASC");

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$items[$key]["cnt"] = ++$cnt;

				$tmp = explode("," , $val["shortcode_device"]);
				$data = null;


				if (in_array("1" , $tmp))
					$data[] = '<span class="f16 sign sign-desktop"></span>';

				if (in_array("2" , $tmp))
					$data[] = '<span class="f16 sign sign-tablet"></span>';

				if (in_array("3" , $tmp))
					$data[] = '<span class="f16 sign sign-mobile"></span>';

				
				if (is_Array($data)) {
					$items[$key]["devices"] = implode(", " , $data);
				} else {
					$items[$key]["devices"] = "";
				}
	
				$items[$key]["options"] =  "";
	
				if ($val["shortcode_attributes"]) {

					$tmp = array();

					if ($val["shortcode_attributes"]) {
						$tmp = unserialize($val["shortcode_attributes"]);
					}
					

					$items[$key]["options"] = count($tmp) ? $base->html->table(
						$this->_t("admin"),
						"Attrs",
						$tmp									
					) : "";

				}
				
				
			}
			
		}

		if (is_array($this->module->plugins)) {
			foreach ($this->module->plugins as $key => $val) {

				if (method_exists($this->module->plugins[$key] , "shortcodesBrowser")) {
					$shortcodes[] = $this->module->plugins[$key]->shortcodesBrowser();												
				}
				
			}			
		}

		$cnt = 1;
		if (is_array($shortcodes)) {
			foreach ($shortcodes as $key => $val) {
				$shortcodes[$key]["code"] = ++$cnt;
			}			
		}

		echo $tpl->blockReplace(
			"Main" , 
			array(
				"manual"	=> $base->html->Table(
					$tpl , 
					"" , 
					$items
				),

				"shortcodes_titles"	=> is_array($shortcodes) ? $base->html->Table(
					$tpl , 
					"Titles",
					$shortcodes
				) : "",

				"shortcodes_content"	=> is_array($shortcodes) ? $base->html->Table(
					$tpl , 
					"Content",
					$shortcodes
				) : ""

			)
		);

		die();
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Duplicate() {
		$old = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:shortcodes']} WHERE shortcode_id=%d" , array($_GET["shortcode_id"]));

		if (is_array($old)) {
			unset($old["shortcode_id"]);

			$old["shortcode_code"] .="copy";

			$id = $this->db->QueryInsert(
				$this->tables["plugin:shortcodes"],
				$old
			);

			urlredirect("index.php?mod=shortcodes&sub=landing&action=edit&shortcode_id={$id}&returnurl=" . urlencode("index.php?mod=shortcodes&sub=landing"));
		}
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCMSFirstRun($module) {
		$this->UpdateShortcodesList();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function UpdateShortcodesList() {

		//debug($this->path,1);

		//get the list of shortcodes from the shortcode folder
		$items = CDir::GetFiles($this->path . "shortcode" , false , ".php");

		foreach ($items as $key => $val) {

			$class = basename($val , ".php");

			if ($class != "shortcodebase") {
				$file = "StemBase\\Modules\\Shortcodes\\Shortcode\\" . $class;
				
				$info = $file::newInstance()
					->getMeta(true);			

				$shortcodes[$info["name"]] = $info;
			}
		
		}
	

		//update the list
		if (is_array($shortcodes)) {

			$old = $this->db->QFetchRowArray(
				"SELECT * FROM {$this->tables['plugin:shortcodes']} WHERE shortcode_engine=2"
			);

			foreach ($old as $key => $val) {
				if (is_array($info = $shortcodes[$val["shortcode_code"]])) {

					if ($val["shortcode_version"] != $info["version"]) {
						$this->db->QueryUpdate(
							$this->tables['plugin:shortcodes'],
							array(
								"shortcode_version"		=> $info["version"],
								"shortcode_class"		=> $info["class"],
								"shortcode_sample"		=> $info["sample"],
								"shortcode_attributes"	=> serialize($info["attributes"]),
								"shortcode_status"		=> "1",
							),
							"shortcode_id={$val[shortcode_id]}"
						);
					}
					
					unset($shortcodes[$val["shortcode_code"]]);
				} else {
					//record a new shortcode
					$remove[] = $val["shortcode_id"];
				}				

				$disable[]= $val["shortcode_code"];
			}
			

			//new shortcodes
			if (count($shortcodes)) {
				foreach ($shortcodes as $key => $info) {
					$this->db->QueryInsert(
						$this->tables['plugin:shortcodes'],
						array(
							"shortcode_engine"		=> "2",
							"shortcode_code"		=> $info["name"],
							"shortcode_device"		=> "1,2,3",
							"shortcode_version"		=> $info["version"],
							"shortcode_class"		=> $info["class"],
							"shortcode_sample"		=> $info["sample"],
							"shortcode_attributes"	=> serialize($info["attributes"]),
							"shortcode_status"		=> "1",
						)
					);
				}				
			}

	
			//remove
			if (is_array($remove) && count($remove)) {
				$this->db->Query("DELETE FROM {$this->tables['plugin:shortcodes']} WHERE shortcode_id IN (%s)", array(implode("," , $remove)));
			}
			
			if (is_array($disable)) {
				//debug($this->db->Statement("shortcode_code in (\"%s\") AND shortcode_engine=1" , array(implode("\",\"" , $disable))),1);

				$this->db->QueryUpdate(
					$this->tables['plugin:shortcodes'],
					array(
						"shortcode_status"	=> "0",
					),
					"shortcode_code in ('" . implode("','" , $disable) . "') AND shortcode_engine=1"
				);
			}
			
			
		}		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ShortcodesList($items , $count) {
		global $base;

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				switch ($val["shortcode_engine"]) {
					//instance
					case "1":
						$items[$key]["shortcode_sample"] = nl2br($val["shortcode_sample"]);
					break;

					//global
					case "2":
						$tmp = array();

						if ($val["shortcode_attributes"]) {
							$tmp = unserialize($val["shortcode_attributes"]);
						}
						

						$items[$key]["shortcode_sample"] = $this->_t("admin")->blockReplace(
							"Item",
							array(
								"sample"	=> nl2br($val["shortcode_sample"]),
								"attrs"		=> count($tmp) ? $base->html->table(
									$this->_t("admin"),
									"Attrs",
									$tmp									
								) : ""
							)
						);						
					break;
				}
			}			
		}

		return array(
			"items"	=> $items,
			"count"	=> $count
		);

	}

		
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Help() {

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM {$this->tables['plugin:shortcodes']} WHERE shortcode_engine=2 order by shortcode_code ASC"
		);


		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$tmp = array();

				if ($val["shortcode_attributes"]) {
					$tmp = unserialize($val["shortcode_attributes"]);

					$html = "";


					foreach ($tmp as $_key => $_val) {

						$html.= "<li>[icon=\"icon-cog\"/]<b>{$_val[name]}</b> - {$_val[hint]}</li>\n";
					}


					echo "<h1>{$val[shortcode_code]}</h1>\n\n";
					echo "<blockquote class=\"classic no-icon\">\n<p><b>Shortcode Attributes:</b></p>\n<ul class=\"text-columns-2 list-with-icons\">\n{$html}</ul>\n</blockquote>\n\n\n";
					
				}
			
			}			
		}

		die();

	}
	
}

?>